/*H**************************************************************************
* NAME:         kbd_4_4.h         
*----------------------------------------------------------------------------
* Copyright (c) 2003 Atmel.
*----------------------------------------------------------------------------
* RELEASE:      c5131-usb-kbd-light-1_0_2      
* REVISION:     1.2     
*----------------------------------------------------------------------------
* PURPOSE: 
* 
*****************************************************************************/

#ifndef _KBD_DRV_H_
#define _KBD_DRV_H_

/*_____ M A C R O S ________________________________________________________*/

#define Kbd_low_level_detection()     (KBLS = 0x00)
#define Kbd_high_level_detection()    (KBLS = 0xFF)


#define Kbd_key_detected()      ((KBF & 0xF0) != 0x00)
#define Kbd_no_key_detected()   ((KBF & 0xF0) == 0x00)
#define Kbd_reset_detected()    (KBF = 0x00)
#define Kbd_flag()              (KBF & 0xF0)


/*_____ D E F I N I T I O N ________________________________________________*/

/*PORT CONFIGURATION*/
/*P1_0 to P1_3 columns (respectively column4 to 1)*/
/*P1_4 to P1_7 rows (respectively row1 to 4)*/  

#define IO_COLUMN_1 P1_3
#define IO_COLUMN_2 P1_2
#define IO_COLUMN_3 P1_1
#define IO_COLUMN_4 P1_0

#define ROW_PORT KBF
#define ROW_ALL ((KBF & 0xF0)>>4)

/*state values*/
#define INIT 0
#define STATE_COLUMN_1 1
#define STATE_COLUMN_2 2
#define STATE_COLUMN_3 3
#define STATE_COLUMN_4 4

/*column number*/
#define COLUMN_1 1
#define COLUMN_2 2
#define COLUMN_3 3
#define COLUMN_4 4

#define SELECT_COLUMN 0 /*the active level is 0*/
#define FREE_COLUMN 1

/*_____ D E C L A R A T I O N ______________________________________________*/

void  kbd_init(void);
void  kbd_test_hit(void);
Uchar kbd_get_char(void);


#endif /* _KBD_DRV_H_ */
